/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.minecraft.framedhopper.block.framedhopper.entity;

import de.markusbordihn.minecraft.framedhopper.block.framedhopper.FramedHopperItemHandler;
import de.markusbordihn.minecraft.framedhopper.utils.ItemHandlerUtils;
import java.util.function.BooleanSupplier;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FramedHopperBlockEntity
extends RandomizableContainerBlockEntity
implements Hopper {
    protected static final Logger log = LogManager.getLogger((String)"Framed Hopper");
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private int cooldownTime = -1;
    protected long tickedGameTime;

    public FramedHopperBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public static void pushItemsTick(Level level, BlockPos blockPos, BlockState blockState, FramedHopperBlockEntity blockEntity) {
        --blockEntity.cooldownTime;
        blockEntity.tickedGameTime = level.m_46467_();
        if (!blockEntity.isOnCooldown()) {
            blockEntity.setCooldown(0);
            FramedHopperBlockEntity.tryMoveItems(level, blockPos, blockState, blockEntity, () -> HopperBlockEntity.m_155552_((Level)level, (Hopper)blockEntity));
        }
    }

    private static boolean tryMoveItems(Level level, BlockPos blockPos, BlockState blockState, FramedHopperBlockEntity blockEntity, BooleanSupplier supplier) {
        if (level.f_46443_) {
            return false;
        }
        if (!blockEntity.isOnCooldown() && Boolean.TRUE.equals(blockState.m_61143_((Property)HopperBlock.f_54022_))) {
            boolean flag = false;
            if (!blockEntity.m_7983_()) {
                flag = FramedHopperBlockEntity.ejectItems(level, blockPos, blockState, blockEntity);
            }
            if (!blockEntity.inventoryFull()) {
                flag |= supplier.getAsBoolean();
            }
            if (flag) {
                blockEntity.setCooldown(8);
                FramedHopperBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
                return true;
            }
        }
        return false;
    }

    private static boolean ejectItems(Level level, BlockPos blockPos, BlockState blockState, FramedHopperBlockEntity blockEntity) {
        Container container = FramedHopperBlockEntity.getAttachedContainer(level, blockPos, blockState);
        if (container == null) {
            IItemHandler itemHandler;
            Direction facing = (Direction)blockState.m_61143_((Property)HopperBlock.f_54021_);
            BlockPos targetPos = blockPos.m_121945_(facing);
            BlockState targetBlockState = level.m_8055_(targetPos);
            BlockEntity targetBlockEntity = level.m_7702_(targetPos);
            if (targetBlockEntity != null && targetBlockState != null && !targetBlockState.m_60795_() && (itemHandler = ItemHandlerUtils.getItemHandler(targetBlockEntity, facing.m_122424_())) != null) {
                int numberOfSlots = itemHandler.getSlots();
                for (int slot = 0; slot < numberOfSlots; ++slot) {
                    for (int i = 0; i < blockEntity.m_6643_(); ++i) {
                        ItemStack itemStackTarget;
                        if (blockEntity.m_8020_(i).m_41619_()) continue;
                        ItemStack itemStack = blockEntity.m_8020_(i).m_41777_();
                        ItemStack removedItem = blockEntity.m_7407_(i, 1);
                        if (removedItem != null && (itemStackTarget = itemHandler.insertItem(slot, removedItem, false)).m_41619_()) {
                            return true;
                        }
                        blockEntity.m_6836_(i, itemStack);
                    }
                }
            }
            return false;
        }
        Direction direction = ((Direction)blockState.m_61143_((Property)HopperBlock.f_54021_)).m_122424_();
        if (FramedHopperBlockEntity.isFullContainer(container, direction)) {
            return false;
        }
        for (int i = 0; i < blockEntity.m_6643_(); ++i) {
            if (blockEntity.m_8020_(i).m_41619_()) continue;
            ItemStack itemStack = blockEntity.m_8020_(i).m_41777_();
            ItemStack itemStackTarget = HopperBlockEntity.m_59326_((Container)blockEntity, (Container)container, (ItemStack)blockEntity.m_7407_(i, 1), (Direction)direction);
            if (itemStackTarget.m_41619_()) {
                container.m_6596_();
                return true;
            }
            blockEntity.m_6836_(i, itemStack);
        }
        return false;
    }

    private static IntStream getSlots(Container container, Direction direction) {
        if (container instanceof WorldlyContainer) {
            WorldlyContainer worldlyContainer = (WorldlyContainer)container;
            return IntStream.of(worldlyContainer.m_7071_(direction));
        }
        return IntStream.range(0, container.m_6643_());
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.hopper");
    }

    public double m_6343_() {
        return (double)this.f_58858_.m_123341_() + 0.5;
    }

    public double m_6358_() {
        return (double)this.f_58858_.m_123342_() + 0.5;
    }

    public double m_6446_() {
        return (double)this.f_58858_.m_123343_() + 0.5;
    }

    @Nullable
    private static Container getAttachedContainer(Level level, BlockPos blockPos, BlockState blockState) {
        Direction direction = (Direction)blockState.m_61143_((Property)HopperBlock.f_54021_);
        return HopperBlockEntity.m_59390_((Level)level, (BlockPos)blockPos.m_121945_(direction));
    }

    public void setCooldown(int coolDown) {
        this.cooldownTime = coolDown;
    }

    private boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    public boolean isOnCustomCooldown() {
        return this.cooldownTime > 8;
    }

    private static boolean isFullContainer(Container container, Direction direction) {
        return FramedHopperBlockEntity.getSlots(container, direction).allMatch(slot -> {
            ItemStack itemStack = container.m_8020_(slot);
            return itemStack.m_41613_() >= itemStack.m_41741_();
        });
    }

    private boolean inventoryFull() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.m_41619_() && itemStack.m_41613_() == itemStack.m_41741_()) continue;
            return false;
        }
        return true;
    }

    public int m_6643_() {
        return this.items.size();
    }

    protected void m_6520_(NonNullList<ItemStack> itemStack) {
        this.items = itemStack;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    public static boolean addItem(Container container, ItemEntity itemEntity) {
        boolean flag = false;
        ItemStack itemStack = itemEntity.m_32055_().m_41777_();
        ItemStack itemStack1 = FramedHopperBlockEntity.addItem(null, container, itemStack, null);
        if (itemStack1.m_41619_()) {
            flag = true;
            itemEntity.m_146870_();
        } else {
            itemEntity.m_32045_(itemStack1);
        }
        return flag;
    }

    public static ItemStack addItem(@Nullable Container container, Container containerTarget, ItemStack itemStack, @Nullable Direction direction) {
        if (containerTarget instanceof WorldlyContainer && direction != null) {
            WorldlyContainer worldlyContainer = (WorldlyContainer)containerTarget;
            int[] slotsForFace = worldlyContainer.m_7071_(direction);
            for (int slot = 0; slot < slotsForFace.length && !itemStack.m_41619_(); ++slot) {
                itemStack = FramedHopperBlockEntity.tryMoveInItem(container, containerTarget, itemStack, slotsForFace[slot], direction);
            }
        } else {
            int i = containerTarget.m_6643_();
            for (int j = 0; j < i && !itemStack.m_41619_(); ++j) {
                itemStack = FramedHopperBlockEntity.tryMoveInItem(container, containerTarget, itemStack, j, direction);
            }
        }
        return itemStack;
    }

    public static void entityInside(Level level, BlockPos blockPos, BlockState blockState, Entity entity, FramedHopperBlockEntity framedHopperBlockEntity) {
        if (entity instanceof ItemEntity && Shapes.m_83157_((VoxelShape)Shapes.m_83064_((AABB)entity.m_20191_().m_82386_((double)(-blockPos.m_123341_()), (double)(-blockPos.m_123342_()), (double)(-blockPos.m_123343_()))), (VoxelShape)framedHopperBlockEntity.m_59300_(), (BooleanOp)BooleanOp.f_82689_)) {
            FramedHopperBlockEntity.tryMoveItems(level, blockPos, blockState, framedHopperBlockEntity, () -> FramedHopperBlockEntity.addItem((Container)framedHopperBlockEntity, (ItemEntity)entity));
        }
    }

    private static boolean canPlaceItemInContainer(Container container, ItemStack itemStack, int slot, @Nullable Direction direction) {
        if (!container.m_7013_(slot, itemStack)) {
            return false;
        }
        return !(container instanceof WorldlyContainer) || ((WorldlyContainer)container).m_7155_(slot, itemStack, direction);
    }

    private static boolean canMergeItems(ItemStack itemStack1, ItemStack itemStack2) {
        return itemStack1.m_41613_() <= itemStack1.m_41741_() && ItemStack.m_150942_((ItemStack)itemStack1, (ItemStack)itemStack2);
    }

    private static ItemStack tryMoveInItem(@Nullable Container framedHopperContainer, Container container, ItemStack itemStack, int slot, @Nullable Direction direction) {
        ItemStack itemStackTarget = container.m_8020_(slot);
        if (FramedHopperBlockEntity.canPlaceItemInContainer(container, itemStack, slot, direction)) {
            boolean flag = false;
            if (itemStackTarget.m_41619_()) {
                container.m_6836_(slot, itemStack);
                itemStack = ItemStack.f_41583_;
                flag = true;
            } else if (FramedHopperBlockEntity.canMergeItems(itemStackTarget, itemStack)) {
                int i = itemStack.m_41741_() - itemStackTarget.m_41613_();
                int j = Math.min(itemStack.m_41613_(), i);
                itemStack.m_41774_(j);
                itemStackTarget.m_41769_(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                FramedHopperBlockEntity framedHopperBlockEntity;
                if (container.m_7983_() && container instanceof FramedHopperBlockEntity && !(framedHopperBlockEntity = (FramedHopperBlockEntity)container).isOnCustomCooldown()) {
                    int k = 0;
                    if (framedHopperContainer instanceof FramedHopperBlockEntity) {
                        FramedHopperBlockEntity hopperBlockEntity = (FramedHopperBlockEntity)framedHopperContainer;
                        if (framedHopperBlockEntity.tickedGameTime >= hopperBlockEntity.tickedGameTime) {
                            k = 1;
                        }
                    }
                    framedHopperBlockEntity.setCooldown(8 - k);
                }
                container.m_6596_();
            }
        }
        return itemStack;
    }

    @Nonnull
    protected AbstractContainerMenu m_6555_(int index, Inventory inventory) {
        return new HopperMenu(index, inventory, (Container)this);
    }

    protected IItemHandler createUnSidedHandler() {
        return new FramedHopperItemHandler(this);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(compoundTag)) {
            ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
        }
        this.cooldownTime = compoundTag.m_128451_("TransferCooldown");
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        if (!this.m_59634_(compoundTag)) {
            ContainerHelper.m_18973_((CompoundTag)compoundTag, this.items);
        }
        compoundTag.m_128405_("TransferCooldown", this.cooldownTime);
    }
}

