/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.vinery.core.entity.ChairEntity;
import net.satisfy.vinery.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class GeneralUtil {
    public static final EnumProperty<LineConnectingType> LINE_CONNECTING_TYPE = EnumProperty.m_61587_((String)"type", LineConnectingType.class);
    private static final Map<ResourceLocation, Map<BlockPos, Pair<ChairEntity, BlockPos>>> CHAIRS = new HashMap<ResourceLocation, Map<BlockPos, Pair<ChairEntity, BlockPos>>>();

    public static RotatedPillarBlock logBlock() {
        return new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_));
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(DeferredRegister<Block> registerB, Registrar<Block> registrarB, DeferredRegister<Item> registerI, Registrar<Item> registrarI, ResourceLocation name, Supplier<T> block) {
        RegistrySupplier toReturn = GeneralUtil.registerWithoutItem(registerB, registrarB, name, block);
        GeneralUtil.registerItem(registerI, registrarI, name, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(DeferredRegister<Block> register, Registrar<Block> registrar, ResourceLocation path, Supplier<T> block) {
        return Platform.isForge() ? register.register(path.m_135815_(), block) : registrar.register(path, block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(DeferredRegister<Item> register, Registrar<Item> registrar, ResourceLocation path, Supplier<T> itemSupplier) {
        return Platform.isForge() ? register.register(path.m_135815_(), itemSupplier) : registrar.register(path, itemSupplier);
    }

    public static Collection<ServerPlayer> tracking(ServerLevel world, ChunkPos pos) {
        Objects.requireNonNull(world, "The world cannot be null");
        Objects.requireNonNull(pos, "The chunk pos cannot be null");
        return world.m_7726_().f_8325_.m_183262_(pos, false);
    }

    public static Collection<ServerPlayer> tracking(ServerLevel world, BlockPos pos) {
        Objects.requireNonNull(pos, "BlockPos cannot be null");
        return GeneralUtil.tracking(world, new ChunkPos(pos));
    }

    public static void popResourceFromFace(Level level, BlockPos blockPos, Direction side, ItemStack itemStack) {
        BlockState blockState = level.m_8055_(blockPos);
        double itemWidth = EntityType.f_20461_.m_20678_();
        double itemHeight = EntityType.f_20461_.m_20679_();
        VoxelShape shape = blockState.m_60812_((BlockGetter)level, blockPos);
        double posX = (double)blockPos.m_123341_() + 0.5;
        double posY = (double)blockPos.m_123342_() + 0.5;
        double posZ = (double)blockPos.m_123343_() + 0.5;
        double offsetX = 0.0;
        double offsetY = 0.0;
        double offsetZ = 0.0;
        switch (side) {
            case DOWN: {
                posY = (double)blockPos.m_123342_() - shape.m_83288_(Direction.Axis.Y);
                offsetY = -itemHeight * 2.0;
                break;
            }
            case UP: {
                posY = (double)blockPos.m_123342_() + shape.m_83297_(Direction.Axis.Y);
                break;
            }
            case NORTH: {
                posZ = (double)blockPos.m_123343_() + shape.m_83288_(Direction.Axis.Z);
                offsetZ = -itemWidth;
                break;
            }
            case SOUTH: {
                posZ = (double)blockPos.m_123343_() + shape.m_83297_(Direction.Axis.Z);
                offsetZ = itemWidth;
                break;
            }
            case WEST: {
                posX = (double)blockPos.m_123341_() + shape.m_83288_(Direction.Axis.X);
                offsetX = -itemWidth;
                break;
            }
            case EAST: {
                posX = (double)blockPos.m_123341_() + shape.m_83297_(Direction.Axis.X);
                offsetX = itemWidth;
            }
        }
        int i = side.m_122429_();
        int j = side.m_122430_();
        int k = side.m_122431_();
        double deltaX = i == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.1, (double)0.1) : (double)i * 0.1;
        double deltaY = j == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)0.0, (double)0.1) : (double)j * 0.1 + 0.1;
        double deltaZ = k == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.1, (double)0.1) : (double)k * 0.1;
        GeneralUtil.popResource(level, new ItemEntity(level, posX + offsetX, posY + offsetY, posZ + offsetZ, itemStack, deltaX, deltaY, deltaZ), itemStack);
    }

    private static void popResource(Level level, ItemEntity itemEntity, ItemStack itemStack) {
        if (!level.f_46443_ && !itemStack.m_41619_() && level.m_46469_().m_46207_(GameRules.f_46136_)) {
            itemEntity.m_32060_();
            level.m_7967_((Entity)itemEntity);
        }
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83148_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (BooleanOp)BooleanOp.f_82695_);
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static Optional<Tuple<Float, Float>> getRelativeHitCoordinatesForBlockFace(BlockHitResult blockHitResult, Direction direction, Direction[] unAllowedDirections) {
        Direction hitDirection = blockHitResult.m_82434_();
        for (Direction unAllowed : unAllowedDirections) {
            if (unAllowed != hitDirection) continue;
            return Optional.empty();
        }
        if (hitDirection != direction && hitDirection != Direction.UP && hitDirection != Direction.DOWN) {
            return Optional.empty();
        }
        BlockPos adjacentPos = blockHitResult.m_82425_().m_121945_(hitDirection);
        Vec3 hitLocation = blockHitResult.m_82450_().m_82492_((double)adjacentPos.m_123341_(), (double)adjacentPos.m_123342_(), (double)adjacentPos.m_123343_());
        float x = (float)hitLocation.m_7096_();
        float z = (float)hitLocation.m_7094_();
        float y = (float)hitLocation.m_7098_();
        Direction effectiveDirection = hitDirection == Direction.UP || hitDirection == Direction.DOWN ? direction : hitDirection;
        return switch (effectiveDirection) {
            case Direction.NORTH -> Optional.of(new Tuple((Object)Float.valueOf(1.0f - x), (Object)Float.valueOf(y)));
            case Direction.SOUTH -> Optional.of(new Tuple((Object)Float.valueOf(x), (Object)Float.valueOf(y)));
            case Direction.WEST -> Optional.of(new Tuple((Object)Float.valueOf(z), (Object)Float.valueOf(y)));
            case Direction.EAST -> Optional.of(new Tuple((Object)Float.valueOf(1.0f - z), (Object)Float.valueOf(y)));
            default -> Optional.empty();
        };
    }

    public static NonNullList<Ingredient> deserializeIngredients(JsonArray json) {
        NonNullList ingredients = NonNullList.m_122779_();
        for (int i = 0; i < json.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get(i));
            if (ingredient.m_43947_()) continue;
            ingredients.add((Object)ingredient);
        }
        return ingredients;
    }

    public static ItemStack convertStackAfterFinishUsing(LivingEntity entity, ItemStack used, Item returnItem, Item usedItem) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            CriteriaTriggers.f_10592_.m_23682_(serverPlayer, used);
            serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)usedItem));
        }
        if (used.m_41619_()) {
            return new ItemStack((ItemLike)returnItem);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!((Player)entity).m_150110_().f_35937_) {
                ItemStack itemStack2 = new ItemStack((ItemLike)returnItem);
                if (!player.m_150109_().m_36054_(itemStack2)) {
                    player.m_36176_(itemStack2, false);
                }
            }
        }
        return used;
    }

    public static InteractionResult onUse(Level world, Player player, InteractionHand hand, BlockHitResult hit, double extraHeight) {
        if (world.f_46443_) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (GeneralUtil.isPlayerSitting(player)) {
            return InteractionResult.PASS;
        }
        if (hit.m_82434_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        BlockPos hitPos = hit.m_82425_();
        if (!GeneralUtil.isOccupied(world, hitPos) && player.m_21120_(hand).m_41619_()) {
            ChairEntity chair = (ChairEntity)((EntityType)EntityTypeRegistry.CHAIR.get()).m_20615_(world);
            assert (chair != null);
            chair.m_7678_((double)hitPos.m_123341_() + 0.5, (double)hitPos.m_123342_() + 0.25 + extraHeight, (double)hitPos.m_123343_() + 0.5, 0.0f, 0.0f);
            if (GeneralUtil.addChairEntity(world, hitPos, chair, player.m_20183_())) {
                world.m_7967_((Entity)chair);
                player.m_20329_((Entity)chair);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static void onStateReplaced(Level world, BlockPos pos) {
        ChairEntity entity;
        if (!world.f_46443_ && (entity = GeneralUtil.getChairEntity(world, pos)) != null) {
            GeneralUtil.removeChairEntity(world, pos);
            entity.m_20153_();
        }
    }

    public static boolean addChairEntity(Level world, BlockPos blockPos, ChairEntity entity, BlockPos playerPos) {
        if (!world.f_46443_) {
            ResourceLocation id = GeneralUtil.getDimensionTypeId(world);
            if (!CHAIRS.containsKey(id)) {
                CHAIRS.put(id, new HashMap());
            }
            CHAIRS.get(id).put(blockPos, (Pair<ChairEntity, BlockPos>)Pair.of((Object)((Object)entity), (Object)playerPos));
            return true;
        }
        return false;
    }

    public static void removeChairEntity(Level world, BlockPos pos) {
        ResourceLocation id;
        if (!world.f_46443_ && CHAIRS.containsKey(id = GeneralUtil.getDimensionTypeId(world))) {
            CHAIRS.get(id).remove(pos);
        }
    }

    public static ChairEntity getChairEntity(Level world, BlockPos pos) {
        ResourceLocation id;
        if (!world.m_5776_() && CHAIRS.containsKey(id = GeneralUtil.getDimensionTypeId(world)) && CHAIRS.get(id).containsKey(pos)) {
            return (ChairEntity)((Object)CHAIRS.get(id).get(pos).getFirst());
        }
        return null;
    }

    public static BlockPos getPreviousPlayerPosition(Player player, ChairEntity chairEntity) {
        ResourceLocation id;
        if (!player.m_9236_().m_5776_() && CHAIRS.containsKey(id = GeneralUtil.getDimensionTypeId(player.m_9236_()))) {
            for (Pair<ChairEntity, BlockPos> pair : CHAIRS.get(id).values()) {
                if (pair.getFirst() != chairEntity) continue;
                return (BlockPos)pair.getSecond();
            }
        }
        return null;
    }

    public static boolean isOccupied(Level world, BlockPos pos) {
        ResourceLocation id = GeneralUtil.getDimensionTypeId(world);
        return CHAIRS.containsKey(id) && CHAIRS.get(id).containsKey(pos);
    }

    public static boolean isPlayerSitting(Player player) {
        for (ResourceLocation i : CHAIRS.keySet()) {
            for (Pair<ChairEntity, BlockPos> pair : CHAIRS.get(i).values()) {
                if (!((ChairEntity)((Object)pair.getFirst())).m_20363_((Entity)player)) continue;
                return true;
            }
        }
        return false;
    }

    private static ResourceLocation getDimensionTypeId(Level world) {
        return world.m_220362_().m_135782_();
    }

    public static enum LineConnectingType implements StringRepresentable
    {
        NONE("none"),
        MIDDLE("middle"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private LineConnectingType(String type) {
            this.name = type;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

