/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.vinery.client.gui.handler.BasketGuiHandler;
import net.satisfy.vinery.core.block.BasketBlock;
import net.satisfy.vinery.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class BasketBlockEntity
extends RandomizableContainerBlockEntity
implements LidBlockEntity {
    private NonNullList<ItemStack> items;
    private final ContainerOpenersCounter openersCounter;
    private final ChestLidController chestLidController = new ChestLidController();

    public BasketBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EntityTypeRegistry.BASKET_ENTITY.get(), blockPos, blockState);
        this.items = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        this.openersCounter = new ContainerOpenersCounter(){

            protected void m_142292_(Level level, BlockPos blockPos, BlockState blockState) {
                BasketBlockEntity.this.playSound(blockState);
            }

            protected void m_142289_(Level level, BlockPos blockPos, BlockState blockState) {
                BasketBlockEntity.this.playSound(blockState);
            }

            protected void m_142148_(Level level, BlockPos blockPos, BlockState blockState, int i, int j) {
                BasketBlockEntity.this.signalOpenCount(level, blockPos, blockState, i, j);
            }

            protected boolean m_142718_(Player player) {
                if (player.f_36096_ instanceof ChestMenu) {
                    Container container = ((ChestMenu)player.f_36096_).m_39261_();
                    return container == BasketBlockEntity.this;
                }
                return false;
            }
        };
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        if (!this.m_59634_(compoundTag)) {
            ContainerHelper.m_18973_((CompoundTag)compoundTag, this.items);
        }
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(compoundTag)) {
            ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
        }
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        return new BasketGuiHandler(i, inventory, (Container)this);
    }

    @NotNull
    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> nonNullList) {
        this.items = nonNullList;
    }

    public int m_6643_() {
        return 9;
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    void playSound(BlockState blockState) {
        Vec3i vec3i = ((Direction)blockState.m_61143_((Property)BasketBlock.FACING)).m_122436_();
        double d = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double e = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double f = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        assert (this.f_58857_ != null);
        this.f_58857_.m_6263_(null, d, e, f, SoundEvents.f_276624_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public float m_6683_(float f) {
        return this.chestLidController.m_155375_(f);
    }

    public static void lidAnimateTick(Level level, BlockPos blockPos, BlockState blockState, BasketBlockEntity basketBlockEntity) {
        basketBlockEntity.chestLidController.m_155374_();
    }

    public boolean m_7531_(int i, int j) {
        if (i == 1) {
            this.chestLidController.m_155377_(j > 0);
            return true;
        }
        return super.m_7531_(i, j);
    }

    protected void signalOpenCount(Level level, BlockPos blockPos, BlockState blockState, int i, int j) {
        Block block = blockState.m_60734_();
        level.m_7696_(blockPos, block, 1, j);
    }
}

