/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.vinery.client.gui.handler.ApplePressGuiHandler;
import net.satisfy.vinery.core.recipe.ApplePressFermentingRecipe;
import net.satisfy.vinery.core.recipe.ApplePressMashingRecipe;
import net.satisfy.vinery.core.registry.EntityTypeRegistry;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.registry.RecipeTypesRegistry;
import net.satisfy.vinery.core.world.ImplementedInventory;
import net.satisfy.vinery.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplePressBlockEntity
extends BlockEntity
implements MenuProvider,
ImplementedInventory,
BlockEntityTicker<ApplePressBlockEntity> {
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    protected final ContainerData propertyDelegate;
    private int progress1 = 0;
    private int maxProgress1 = PlatformHelper.getApplePressMashingTime();
    private int progress2 = 0;
    private int maxProgress2 = PlatformHelper.getApplePressFermentationTime();

    public ApplePressBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.APPLE_PRESS_BLOCK_ENTITY.get(), pos, state);
        this.propertyDelegate = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> ApplePressBlockEntity.this.progress1;
                    case 1 -> ApplePressBlockEntity.this.maxProgress1;
                    case 2 -> ApplePressBlockEntity.this.progress2;
                    case 3 -> ApplePressBlockEntity.this.maxProgress2;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        ApplePressBlockEntity.this.progress1 = value;
                        break;
                    }
                    case 1: {
                        ApplePressBlockEntity.this.maxProgress1 = value;
                        break;
                    }
                    case 2: {
                        ApplePressBlockEntity.this.progress2 = value;
                        break;
                    }
                    case 3: {
                        ApplePressBlockEntity.this.maxProgress2 = value;
                    }
                }
            }

            public int m_6499_() {
                return 4;
            }
        };
    }

    @Override
    public int @NotNull [] m_7071_(Direction side) {
        if (side == Direction.DOWN) {
            return new int[]{3};
        }
        if (side.m_122434_().m_122479_()) {
            return new int[]{0, 1, 2};
        }
        return new int[0];
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new ApplePressGuiHandler(syncId, inv, (Container)this, this.propertyDelegate);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("apple_press.progress1", this.progress1);
        nbt.m_128405_("apple_press.progress2", this.progress2);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.progress1 = nbt.m_128451_("apple_press.progress1");
        this.progress2 = nbt.m_128451_("apple_press.progress2");
    }

    public void tick(Level world, BlockPos pos, BlockState state, ApplePressBlockEntity entity) {
        if (world.m_5776_()) {
            return;
        }
        boolean dirty = false;
        if (ApplePressBlockEntity.hasInput(entity, 0)) {
            Recipe recipe1 = world.m_7465_().m_44015_((RecipeType)RecipeTypesRegistry.APPLE_PRESS_MASHING_RECIPE_TYPE.get(), (Container)entity, world).orElse(null);
            if (recipe1 instanceof ApplePressMashingRecipe) {
                ApplePressMashingRecipe mashingRecipe = (ApplePressMashingRecipe)recipe1;
                if (ApplePressBlockEntity.canProcessMashing(entity, mashingRecipe)) {
                    ++entity.progress1;
                    if (entity.progress1 >= entity.maxProgress1) {
                        ApplePressBlockEntity.processMashing(entity, mashingRecipe);
                        dirty = true;
                    }
                } else {
                    entity.progress1 = 0;
                }
            } else {
                entity.progress1 = 0;
            }
        } else {
            entity.progress1 = 0;
        }
        if (ApplePressBlockEntity.hasInput(entity, 1)) {
            Recipe recipe2 = world.m_7465_().m_44015_((RecipeType)RecipeTypesRegistry.APPLE_PRESS_FERMENTING_RECIPE_TYPE.get(), (Container)entity, world).orElse(null);
            if (recipe2 instanceof ApplePressFermentingRecipe) {
                ApplePressFermentingRecipe fermentingRecipe = (ApplePressFermentingRecipe)recipe2;
                if (ApplePressBlockEntity.canProcessFermenting(entity, fermentingRecipe)) {
                    ++entity.progress2;
                    if (entity.progress2 >= entity.maxProgress2) {
                        ApplePressBlockEntity.processFermenting(entity, fermentingRecipe);
                        dirty = true;
                    }
                } else {
                    entity.progress2 = 0;
                }
            } else {
                entity.progress2 = 0;
            }
        } else {
            entity.progress2 = 0;
        }
        if (dirty) {
            ApplePressBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    private static boolean hasInput(ApplePressBlockEntity entity, int slot) {
        return !entity.m_8020_(slot).m_41619_();
    }

    private static boolean canProcessMashing(ApplePressBlockEntity entity, ApplePressMashingRecipe recipe) {
        ItemStack input = entity.m_8020_(0);
        ItemStack output = entity.m_8020_(1);
        if (!recipe.m_5818_((Container)new SimpleContainer(new ItemStack[]{input}), entity.f_58857_)) {
            return false;
        }
        if (output.m_41619_()) {
            return true;
        }
        assert (entity.f_58857_ != null);
        return output.m_41720_() == recipe.m_8043_(entity.f_58857_.m_9598_()).m_41720_();
    }

    private static void processMashing(ApplePressBlockEntity entity, ApplePressMashingRecipe recipe) {
        entity.m_7407_(0, 1);
        assert (entity.f_58857_ != null);
        ItemStack result = recipe.m_8043_(entity.f_58857_.m_9598_()).m_41777_();
        ItemStack outputSlot = entity.m_8020_(1);
        if (outputSlot.m_41619_()) {
            entity.m_6836_(1, result);
        } else {
            outputSlot.m_41769_(result.m_41613_());
        }
        entity.progress1 = 0;
    }

    private static boolean canProcessFermenting(ApplePressBlockEntity entity, ApplePressFermentingRecipe recipe) {
        ItemStack bottle;
        if (!recipe.m_5818_((Container)entity, entity.f_58857_)) {
            return false;
        }
        if (recipe.requiresBottle() && !ApplePressBlockEntity.isWineBottle(bottle = entity.m_8020_(2))) {
            return false;
        }
        ItemStack output = entity.m_8020_(3);
        if (output.m_41619_()) {
            return true;
        }
        assert (entity.f_58857_ != null);
        return output.m_41720_() == recipe.m_8043_(entity.f_58857_.m_9598_()).m_41720_();
    }

    private static void processFermenting(ApplePressBlockEntity entity, ApplePressFermentingRecipe recipe) {
        entity.m_7407_(1, 1);
        if (recipe.requiresBottle()) {
            entity.m_7407_(2, 1);
        }
        assert (entity.f_58857_ != null);
        ItemStack result = recipe.m_8043_(entity.f_58857_.m_9598_()).m_41777_();
        ItemStack outputSlot = entity.m_8020_(3);
        if (outputSlot.m_41619_()) {
            entity.m_6836_(3, result);
        } else {
            outputSlot.m_41769_(result.m_41613_());
        }
        entity.progress2 = 0;
    }

    private static boolean isWineBottle(ItemStack stack) {
        return stack.m_41720_() == ObjectRegistry.WINE_BOTTLE.get();
    }

    @Override
    public boolean m_6542_(Player player) {
        return this.f_58857_ != null && this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return switch (index) {
            case 0 -> true;
            case 2 -> {
                if (stack.m_41720_() == ObjectRegistry.WINE_BOTTLE.get()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        assert (direction != null);
        if (direction.m_122434_().m_122479_()) {
            return switch (index) {
                case 0 -> this.isValidForApplePressMashing(stack);
                case 1 -> this.isValidForFermentationBarrel(stack);
                case 2 -> ApplePressBlockEntity.isWineBottle(stack);
                default -> false;
            };
        }
        return false;
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index == 3 && (direction == Direction.DOWN || direction.m_122434_().m_122479_());
    }

    private boolean isValidForApplePressMashing(ItemStack stack) {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.f_58857_.m_7465_().m_44013_((RecipeType)RecipeTypesRegistry.APPLE_PRESS_MASHING_RECIPE_TYPE.get()).stream().anyMatch(recipe -> recipe.m_7527_().stream().anyMatch(ingredient -> ingredient.test(stack)));
    }

    private boolean isValidForFermentationBarrel(ItemStack stack) {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.f_58857_.m_7465_().m_44013_((RecipeType)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_TYPE.get()).stream().anyMatch(recipe -> recipe.m_7527_().stream().anyMatch(ingredient -> ingredient.test(stack)));
    }
}

