/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.region;

import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferArena;
import me.jellysquid.mods.sodium.client.gl.arena.PendingUpload;
import me.jellysquid.mods.sodium.client.gl.arena.staging.FallbackStagingBuffer;
import me.jellysquid.mods.sodium.client.gl.arena.staging.MappedStagingBuffer;
import me.jellysquid.mods.sodium.client.gl.arena.staging.StagingBuffer;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import me.jellysquid.mods.sodium.client.render.chunk.data.BuiltSectionMeshParts;
import me.jellysquid.mods.sodium.client.render.chunk.data.SectionRenderDataStorage;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import org.jetbrains.annotations.NotNull;

public class RenderRegionManager {
    private final Long2ReferenceOpenHashMap<RenderRegion> regions = new Long2ReferenceOpenHashMap();
    private final StagingBuffer stagingBuffer;

    public RenderRegionManager(CommandList commandList) {
        this.stagingBuffer = RenderRegionManager.createStagingBuffer(commandList);
    }

    public void update() {
        this.stagingBuffer.flip();
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            ObjectIterator it = this.regions.values().iterator();
            while (it.hasNext()) {
                RenderRegion region = (RenderRegion)it.next();
                region.update(commandList);
                if (!region.isEmpty()) continue;
                region.delete(commandList);
                it.remove();
            }
        }
    }

    public void uploadMeshes(CommandList commandList, Collection<ChunkBuildOutput> results) {
        for (Reference2ReferenceMap.Entry entry : this.createMeshUploadQueues(results)) {
            this.uploadMeshes(commandList, (RenderRegion)entry.getKey(), ((List)entry.getValue()).stream().filter(o -> !o.isIndexOnlyUpload()).toList());
            this.uploadResorts(commandList, (RenderRegion)entry.getKey(), ((List)entry.getValue()).stream().filter(ChunkBuildOutput::isIndexOnlyUpload).toList());
        }
    }

    private void uploadMeshes(CommandList commandList, RenderRegion region, Collection<ChunkBuildOutput> results) {
        ArrayList<PendingSectionUpload> uploads = new ArrayList<PendingSectionUpload>();
        for (ChunkBuildOutput result : results) {
            for (TerrainRenderPass pass : DefaultTerrainRenderPasses.ALL) {
                BuiltSectionMeshParts mesh;
                SectionRenderDataStorage storage = region.getStorage(pass);
                if (storage != null) {
                    storage.removeMeshes(result.render.getSectionIndex());
                }
                if ((mesh = result.getMesh(pass)) == null) continue;
                uploads.add(new PendingSectionUpload(result.render, mesh, pass, new PendingUpload(mesh.getVertexData()), mesh.getIndexData() != null ? new PendingUpload(mesh.getIndexData()) : null));
            }
        }
        if (uploads.isEmpty()) {
            return;
        }
        RenderRegion.DeviceResources resources = region.createResources(commandList);
        GlBufferArena geometryArena = resources.getGeometryArena();
        boolean bufferChanged = geometryArena.upload(commandList, uploads.stream().map(upload -> upload.vertexUpload));
        if (bufferChanged |= resources.getIndexArena().upload(commandList, uploads.stream().map(upload -> upload.indexUpload).filter(Objects::nonNull))) {
            region.refresh(commandList);
        }
        for (PendingSectionUpload upload2 : uploads) {
            SectionRenderDataStorage storage = region.createStorage(upload2.pass);
            storage.setMeshes(upload2.section.getSectionIndex(), upload2.vertexUpload.getResult(), upload2.indexUpload != null ? upload2.indexUpload.getResult() : null, upload2.meshData.getVertexRanges());
        }
    }

    private void uploadResorts(CommandList commandList, RenderRegion region, Collection<ChunkBuildOutput> results) {
        ArrayList<PendingResortUpload> uploads = new ArrayList<PendingResortUpload>();
        for (ChunkBuildOutput result : results) {
            for (TerrainRenderPass pass : DefaultTerrainRenderPasses.ALL) {
                BuiltSectionMeshParts mesh = result.getMesh(pass);
                if (mesh == null) continue;
                SectionRenderDataStorage storage = region.getStorage(pass);
                if (storage != null) {
                    storage.removeIndexBuffer(result.render.getSectionIndex());
                }
                Objects.requireNonNull(mesh.getIndexData());
                uploads.add(new PendingResortUpload(result.render, mesh, pass, new PendingUpload(mesh.getIndexData())));
            }
        }
        if (uploads.isEmpty()) {
            return;
        }
        RenderRegion.DeviceResources resources = region.createResources(commandList);
        boolean bufferChanged = resources.getIndexArena().upload(commandList, uploads.stream().map(upload -> upload.indexUpload).filter(Objects::nonNull));
        if (bufferChanged) {
            region.refresh(commandList);
        }
        for (PendingResortUpload upload2 : uploads) {
            SectionRenderDataStorage storage = region.createStorage(upload2.pass);
            storage.replaceIndexBuffer(upload2.section.getSectionIndex(), upload2.indexUpload.getResult());
        }
    }

    private Reference2ReferenceMap.FastEntrySet<RenderRegion, List<ChunkBuildOutput>> createMeshUploadQueues(Collection<ChunkBuildOutput> results) {
        Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
        for (ChunkBuildOutput result : results) {
            List queue = (List)map.computeIfAbsent((Object)result.render.getRegion(), k -> new ArrayList());
            queue.add(result);
        }
        return map.reference2ReferenceEntrySet();
    }

    public void delete(CommandList commandList) {
        for (RenderRegion region : this.regions.values()) {
            region.delete(commandList);
        }
        this.regions.clear();
        this.stagingBuffer.delete(commandList);
    }

    public Collection<RenderRegion> getLoadedRegions() {
        return this.regions.values();
    }

    public StagingBuffer getStagingBuffer() {
        return this.stagingBuffer;
    }

    public RenderRegion createForChunk(int chunkX, int chunkY, int chunkZ) {
        return this.create(chunkX >> RenderRegion.REGION_WIDTH_SH, chunkY >> RenderRegion.REGION_HEIGHT_SH, chunkZ >> RenderRegion.REGION_LENGTH_SH);
    }

    @NotNull
    private RenderRegion create(int x, int y, int z) {
        long key = RenderRegion.key(x, y, z);
        RenderRegion instance = (RenderRegion)this.regions.get(key);
        if (instance == null) {
            instance = new RenderRegion(x, y, z, this.stagingBuffer);
            this.regions.put(key, (Object)instance);
        }
        return instance;
    }

    private static StagingBuffer createStagingBuffer(CommandList commandList) {
        if (SodiumClientMod.options().advanced.useAdvancedStagingBuffers && MappedStagingBuffer.isSupported(RenderDevice.INSTANCE)) {
            return new MappedStagingBuffer(commandList);
        }
        return new FallbackStagingBuffer(commandList);
    }

    private record PendingSectionUpload(RenderSection section, BuiltSectionMeshParts meshData, TerrainRenderPass pass, PendingUpload vertexUpload, PendingUpload indexUpload) {
        private PendingSectionUpload(RenderSection section, BuiltSectionMeshParts meshData, TerrainRenderPass pass, PendingUpload vertexUpload) {
            this(section, meshData, pass, vertexUpload, null);
        }
    }

    private record PendingResortUpload(RenderSection section, BuiltSectionMeshParts meshData, TerrainRenderPass pass, PendingUpload indexUpload) {
    }
}

