/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.core;

import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.block.ChalkMarkBlock;
import io.github.mortuusars.chalk.core.IDrawingTool;
import io.github.mortuusars.chalk.core.MarkSymbol;
import io.github.mortuusars.chalk.core.SymbolOrientation;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class Mark {
    public final Direction facing;
    public final int color;
    public final MarkSymbol symbol;
    public final SymbolOrientation orientation;
    public final boolean glowing;

    public Mark(Direction facing, int color, MarkSymbol symbol, SymbolOrientation orientation, boolean glowing) {
        this.facing = facing;
        this.color = color;
        this.symbol = symbol;
        this.orientation = orientation;
        this.glowing = glowing;
    }

    public BlockState createBlockState(ItemStack drawingItem) {
        DyeColor color = DyeColor.WHITE;
        Item item = drawingItem.m_41720_();
        if (item instanceof IDrawingTool) {
            IDrawingTool drawingTool = (IDrawingTool)item;
            color = drawingTool.getMarkColor(drawingItem).orElse(color);
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)Chalk.Blocks.getMarkBlock(color).m_49966_().m_61124_((Property)ChalkMarkBlock.FACING, (Comparable)this.facing)).m_61124_(ChalkMarkBlock.SYMBOL, (Comparable)((Object)this.symbol))).m_61124_(ChalkMarkBlock.ORIENTATION, (Comparable)((Object)this.orientation))).m_61124_((Property)ChalkMarkBlock.GLOWING, (Comparable)Boolean.valueOf(this.glowing));
    }

    public static Mark fromBuffer(FriendlyByteBuf buffer) {
        return new Mark((Direction)buffer.m_130066_(Direction.class), buffer.readInt(), (MarkSymbol)buffer.m_130066_(MarkSymbol.class), (SymbolOrientation)buffer.m_130066_(SymbolOrientation.class), buffer.readBoolean());
    }

    public void toBuffer(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.facing);
        buffer.writeInt(this.color);
        buffer.m_130068_((Enum)this.symbol);
        buffer.m_130068_((Enum)this.orientation);
        buffer.writeBoolean(this.glowing);
    }
}

