/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.data.providers;

import com.alekiponi.alekiships.common.block.AlekiShipsBlocks;
import com.alekiponi.alekiships.common.entity.AlekiShipsEntities;
import com.alekiponi.alekiships.common.item.AlekiShipsItems;
import com.alekiponi.alekiships.data.DataGenHelper;
import com.alekiponi.alekiships.data.SmartLanguageProvider;
import com.alekiponi.alekiships.data.providers.AlekiShipsAdvancementsProvider;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

public class AlekiShipsLanguageProvider
extends SmartLanguageProvider {
    public AlekiShipsLanguageProvider(PackOutput output) {
        super(output, "alekiships", "en_us");
    }

    @Override
    protected void addTranslations() {
        this.addTranslationsForBlocks();
        this.addTranslationsForItems();
        this.addTranslationsForEntities();
        this.add("creativetab.alekiships_tab", "aleki's Nifty Ships");
        this.add("alekiships.failed_multiblock_detection", "No Valid Hull Structure Found");
        this.add("alekiships.config.server.windAffectsBoatsWithNoAnchor", "Wind Affects Boats With No Anchor");
        this.add("press_button", "Press");
        this.add("eject_passengers", "to eject");
        this.addTranslationsForJade();
        AlekiShipsAdvancementsProvider.addTranslations(this::add);
    }

    private void addTranslationsForBlocks() {
        AlekiShipsBlocks.WOODEN_BOAT_FRAME_FLAT.forEach((wood, registryObject) -> this.addBlock((Supplier<? extends Block>)registryObject, String.format(Locale.ROOT, "%s Flat Shipwright's Scaffolding", DataGenHelper.langify(wood.m_7912_()))));
        AlekiShipsBlocks.WOODEN_BOAT_FRAME_ANGLED.forEach((wood, registryObject) -> this.addBlock((Supplier<? extends Block>)registryObject, String.format(Locale.ROOT, "%s Sloped Shipwright's Scaffolding", DataGenHelper.langify(wood.m_7912_()))));
        this.addBlock((Supplier<? extends Block>)AlekiShipsBlocks.BOAT_FRAME_ANGLED, "Sloped Shipwright's Scaffolding");
        this.addBlock((Supplier<? extends Block>)AlekiShipsBlocks.BOAT_FRAME_FLAT, "Flat Shipwright's Scaffolding");
        this.addBlock((Supplier<? extends Block>)AlekiShipsBlocks.OARLOCK, "Oarlock");
        this.addBlock((Supplier<? extends Block>)AlekiShipsBlocks.CLEAT, "Cleat");
    }

    private void addTranslationsForItems() {
        this.addItem((Supplier<? extends Item>)AlekiShipsItems.CANNON, "Cannon");
        this.addItem((Supplier<? extends Item>)AlekiShipsItems.CANNONBALL, "Cannonball");
        this.addItem((Supplier<? extends Item>)AlekiShipsItems.ANCHOR, "Anchor");
        this.addItem((Supplier<? extends Item>)AlekiShipsItems.SLOOP_ICON_ONLY, "Sloop (ICON ONLY)");
        this.addItem((Supplier<? extends Item>)AlekiShipsItems.ROWBOAT_ICON_ONLY, "Rowboat (ICON ONLY)");
        this.addItem((Supplier<? extends Item>)AlekiShipsItems.OAR, "Oar");
        this.add("item.alekiships.music_disc_pirate_crafting.desc", "Captain Thrack - Pirate Crafting");
        this.addItem((Supplier<? extends Item>)AlekiShipsItems.MUSIC_DISC_PIRATE_CRAFTING, "Music Disc");
    }

    private void addTranslationsForEntities() {
        AlekiShipsEntities.ROWBOATS.forEach((wood, registryObject) -> this.addEntityType((Supplier<? extends EntityType<?>>)registryObject, String.format(Locale.ROOT, "%s Rowboat", DataGenHelper.langify(wood.m_7912_()))));
        AlekiShipsEntities.SLOOPS.forEach((wood, registryObject) -> this.addEntityType((Supplier<? extends EntityType<?>>)registryObject, String.format(Locale.ROOT, "%s Sloop", DataGenHelper.langify(wood.m_7912_()))));
        AlekiShipsEntities.SLOOPS_UNDER_CONSTRUCTION.forEach((wood, registryObject) -> this.addEntityType((Supplier<? extends EntityType<?>>)registryObject, String.format(Locale.ROOT, "%s Sloop", DataGenHelper.langify(wood.m_7912_()))));
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.VEHICLE_PART, "Vehicle Part");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.VEHICLE_CLEAT_ENTITY, "Cleat");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.WINDLASS_SWITCH_ENTITY, "Windlass");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.SAIL_SWITCH_ENTITY, "Sail");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.VEHICLE_COLLIDER_ENTITY, "Vehicle");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.CONSTRUCTION_ENTITY, "Construction Entity");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.MAST_ENTITY, "Mast");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.ANCHOR_ENTITY, "Anchor");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.CANNONBALL_ENTITY, "Cannonball");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.CANNON_ENTITY, "Cannon");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.EMPTY_COMPARTMENT_ENTITY, "Empty Compartment");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.BLOCK_COMPARTMENT_ENTITY, "Block Compartment");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.BARREL_COMPARTMENT_ENTITY, "Barrel Compartment");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.CHEST_COMPARTMENT_ENTITY, "Chest Compartment");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.ENDER_CHEST_COMPARTMENT_ENTITY, "Ender Chest Compartment");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.SHULKER_BOX_COMPARTMENT_ENTITY, "Shulker Box Compartment");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.FURNACE_COMPARTMENT_ENTITY, "Furnace Compartment");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.BLAST_FURNACE_COMPARTMENT_ENTITY, "Blast Furnace Compartment");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.SMOKER_COMPARTMENT_ENTITY, "Smoker Compartment");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.BREWING_STAND_COMPARTMENT_ENTITY, "Brewing Stand Compartment");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.WORKBENCH_COMPARTMENT_ENTITY, "Workbench Compartment");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.STONECUTTER_COMPARTMENT_ENTITY, "Stonecutter Compartment");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.CARTOGRAPHY_TABLE_COMPARTMENT_ENTITY, "Cartography Table Compartment");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.SMITHING_TABLE_COMPARTMENT_ENTITY, "Smithing Table Compartment");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.GRINDSTONE_COMPARTMENT_ENTITY, "Grindstone Compartment");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.LOOM_COMPARTMENT_ENTITY, "Loom Compartment");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.NOTE_BLOCK_COMPARTMENT_ENTITY, "Note Block Compartment");
        this.addEntityType((Supplier<? extends EntityType<?>>)AlekiShipsEntities.JUKEBOX_COMPARTMENT_ENTITY, "Jukebox Compartment");
    }

    private void addTranslationsForJade() {
        this.add("config.jade.plugin_alekiships.jukebox", "Jukebox Compartment");
        this.add("config.jade.plugin_alekiships.note_block", "Note Block Compartment");
        this.add("config.jade.plugin_alekiships.furnace", "Furnace Compartment");
        this.add("config.jade.plugin_alekiships.brewing_stand", "Brewing Stand Compartment");
        this.add("config.jade.plugin_alekiships.block", "Block Compartment");
        this.add("alekiships.jade.compartment_block", "%s Compartment");
    }

    @Override
    protected Iterable<Block> getKnownBlocks() {
        return AlekiShipsBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
    }

    @Override
    protected Iterable<Item> getKnownItems() {
        return AlekiShipsItems.ITEMS.getEntries().stream().map(RegistryObject::get)::iterator;
    }

    @Override
    protected Iterable<EntityType<?>> getKnownEntityTypes() {
        return AlekiShipsEntities.ENTITY_TYPES.getEntries().stream().map(RegistryObject::get)::iterator;
    }

    public static interface TranslationWriter {
        public void add(String var1, String var2);
    }
}

