/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla;

import com.alekiponi.alekiships.common.entity.vehiclehelper.CompartmentType;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.BlockCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.CompartmentCloneable;
import com.alekiponi.alekiships.network.ClientboundJukeboxStartMusicPacket;
import com.alekiponi.alekiships.network.ClientboundJukeboxStopMusicPacket;
import com.alekiponi.alekiships.network.PacketHandler;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.ContainerSingleItem;
import net.minecraftforge.network.PacketDistributor;

public class JukeboxCompartmentEntity
extends BlockCompartmentEntity
implements ContainerSingleItem,
CompartmentCloneable {
    private static final int SONG_END_PADDING = 20;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    private int ticksSinceLastEvent;
    private long tickCount;
    private long recordStartedTick;
    private boolean isPlaying;

    public JukeboxCompartmentEntity(CompartmentType<? extends JukeboxCompartmentEntity> compartmentType, Level level) {
        super((CompartmentType<? extends BlockCompartmentEntity>)compartmentType, level);
    }

    public JukeboxCompartmentEntity(CompartmentType<? extends JukeboxCompartmentEntity> compartmentType, Level level, ItemStack itemStack) {
        super(compartmentType, level, itemStack);
        CompoundTag compoundtag = BlockItem.m_186336_((ItemStack)itemStack);
        if (compoundtag != null && compoundtag.m_128441_("RecordItem")) {
            this.readCommonNBTData(compoundtag);
        }
    }

    @Override
    public void m_8119_() {
        Item item;
        super.m_8119_();
        ++this.ticksSinceLastEvent;
        if (this.isRecordPlaying() && (item = this.m_272036_().m_41720_()) instanceof RecordItem) {
            RecordItem recorditem = (RecordItem)item;
            if (this.shouldRecordStopPlaying(recorditem)) {
                this.stopPlaying();
            } else if (this.shouldSendJukeboxPlayingEvent()) {
                this.ticksSinceLastEvent = 0;
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123758_, this.m_20185_(), this.m_20186_() + 1.2, this.m_20189_(), 0, (double)((float)serverLevel.m_213780_().m_188503_(4) / 24.0f), 0.0, 0.0, 1.0);
                }
            }
        }
        ++this.tickCount;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (((Boolean)this.getDisplayBlockState().m_61143_((Property)JukeboxBlock.f_54254_)).booleanValue()) {
            this.popOutRecord();
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_204117_(ItemTags.f_13158_)) {
            this.m_272287_(heldItem.m_41620_(1));
            player.m_36220_(Stats.f_12965_);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void onBreak() {
        super.onBreak();
        this.popOutRecord();
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.readCommonNBTData(compoundTag);
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        this.writeCommonNBTData(compoundTag);
    }

    private void readCommonNBTData(CompoundTag compoundTag) {
        if (compoundTag.m_128425_("RecordItem", 10)) {
            this.items.set(0, (Object)ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("RecordItem")));
            this.setDisplayBlockState((BlockState)this.getDisplayBlockState().m_61124_((Property)JukeboxBlock.f_54254_, (Comparable)Boolean.valueOf(true)));
        }
        this.isPlaying = compoundTag.m_128471_("IsPlaying");
        this.recordStartedTick = compoundTag.m_128454_("RecordStartTick");
        this.tickCount = compoundTag.m_128454_("TickCount");
    }

    private void writeCommonNBTData(CompoundTag compoundTag) {
        if (!this.m_272036_().m_41619_()) {
            compoundTag.m_128365_("RecordItem", (Tag)this.m_272036_().m_41739_(new CompoundTag()));
        }
        compoundTag.m_128379_("IsPlaying", this.isPlaying);
        compoundTag.m_128356_("RecordStartTick", this.recordStartedTick);
        compoundTag.m_128356_("TickCount", this.tickCount);
    }

    @Override
    public CompoundTag saveForItemStack() {
        CompoundTag compoundTag = new CompoundTag();
        this.writeCommonNBTData(compoundTag);
        return compoundTag;
    }

    public ItemStack m_8020_(int slotIndex) {
        return (ItemStack)this.items.get(slotIndex);
    }

    public void m_6836_(int slotIndex, ItemStack itemStack) {
        if (itemStack.m_204117_(ItemTags.f_13158_)) {
            this.items.set(slotIndex, (Object)itemStack);
            this.setDisplayBlockState((BlockState)this.getDisplayBlockState().m_61124_((Property)JukeboxBlock.f_54254_, (Comparable)Boolean.valueOf(true)));
            this.startPlaying();
        }
    }

    public ItemStack m_7407_(int slotIndex, int amount) {
        ItemStack itemStack = Objects.requireNonNullElse((ItemStack)this.items.get(slotIndex), ItemStack.f_41583_);
        this.items.set(slotIndex, (Object)ItemStack.f_41583_);
        if (!itemStack.m_41619_()) {
            this.setDisplayBlockState((BlockState)this.getDisplayBlockState().m_61124_((Property)JukeboxBlock.f_54254_, (Comparable)Boolean.valueOf(false)));
            this.stopPlaying();
        }
        return itemStack;
    }

    public boolean m_7013_(int slotIndex, ItemStack itemStack) {
        return itemStack.m_204117_(ItemTags.f_13158_) && this.m_8020_(slotIndex).m_41619_();
    }

    public boolean m_271862_(Container container, int slotIndex, ItemStack itemStack) {
        return container.m_216874_(ItemStack::m_41619_);
    }

    public boolean m_6542_(Player player) {
        return !this.m_213877_() && this.m_20182_().m_82509_((Position)player.m_20182_(), 8.0);
    }

    public final void popOutRecord() {
        ItemStack itemStack = this.m_272036_();
        if (!itemStack.m_41619_()) {
            this.m_272108_();
            double yPos = this.m_20186_();
            for (Entity entity : this.m_9236_().m_6249_((Entity)this, this.m_20191_(), Entity::m_5829_)) {
                if (!(entity.m_20191_().f_82292_ > yPos)) continue;
                yPos = entity.m_20191_().f_82292_;
            }
            Containers.m_18992_((Level)this.m_9236_(), (double)this.m_20185_(), (double)yPos, (double)this.m_20189_(), (ItemStack)itemStack);
        }
    }

    private void startPlaying() {
        this.recordStartedTick = this.tickCount;
        this.isPlaying = true;
        if (!this.m_9236_().f_46443_) {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), new ClientboundJukeboxStartMusicPacket(this, this.m_272036_().m_41720_()));
        }
        this.m_6596_();
    }

    private void stopPlaying() {
        this.isPlaying = false;
        if (!this.m_9236_().f_46443_) {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), new ClientboundJukeboxStopMusicPacket(this));
        }
        this.m_6596_();
    }

    private boolean shouldRecordStopPlaying(RecordItem recorditem) {
        return this.tickCount >= this.recordStartedTick + (long)recorditem.m_43036_() + 20L;
    }

    private boolean shouldSendJukeboxPlayingEvent() {
        return this.ticksSinceLastEvent >= 20;
    }

    private boolean isRecordPlaying() {
        return !this.m_272036_().m_41619_() && this.isPlaying;
    }

    public int m_6893_() {
        return 1;
    }

    public void m_6596_() {
    }
}

