/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehiclehelper;

import com.alekiponi.alekiships.AlekiShips;
import com.alekiponi.alekiships.common.entity.AlekiShipsEntities;
import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveAnchorWindlass;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveCleats;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveColliders;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveConstructionEntities;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveMasts;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveSailSwitches;
import com.alekiponi.alekiships.common.entity.vehiclehelper.AbstractSwitchEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.CleatEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.ColliderEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.CompartmentType;
import com.alekiponi.alekiships.common.entity.vehiclehelper.ConstructionEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.MastEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.WindlassSwitchEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.AbstractCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.EmptyCompartmentEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class VehiclePart
extends Entity {
    protected static final EntityDataAccessor<Float> DATA_ID_COMPARTMENT_ROTATION = SynchedEntityData.m_135353_(VehiclePart.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int selfDestructTicks = 0;

    public VehiclePart(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public void m_8119_() {
        if (!this.m_9236_().m_5776_()) {
            Entity object;
            if (!this.m_20159_()) {
                ++this.selfDestructTicks;
                if (this.selfDestructTicks++ >= 5) {
                    this.m_20153_();
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
            if (!((object = this.m_20202_()) instanceof AbstractVehicle)) {
                return;
            }
            AbstractVehicle vehicle = (AbstractVehicle)object;
            if (this.f_19797_ < 30 && vehicle.m_20197_().size() == vehicle.getMaxPassengers()) {
                for (int[] i : vehicle.getCompartmentRotationsArray()) {
                    if (vehicle.m_20197_().get(i[0]) != this) continue;
                    this.setCompartmentRotation(i[1]);
                }
            }
            if (this.m_20197_().isEmpty() && vehicle.m_20197_().size() == vehicle.getMaxPassengers()) {
                this.tickAddAppropriateHelper(vehicle);
            }
        }
        super.m_8119_();
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        Entity entity = this.m_20202_();
        if (!(entity instanceof AbstractVehicle)) {
            return;
        }
        AbstractVehicle abstractVehicle = (AbstractVehicle)entity;
        double localY = (this.m_213877_() ? 0.01 : this.m_6048_()) + passenger.m_6049_();
        moveFunction.m_20372_(passenger, this.m_20185_(), this.m_20186_() + localY, this.m_20189_());
        passenger.m_6034_(this.m_20185_(), this.m_20186_() + localY, this.m_20189_());
        if (passenger instanceof AbstractCompartmentEntity || passenger instanceof CleatEntity) {
            this.m_146922_(abstractVehicle.m_146908_());
            passenger.m_146922_(this.m_146908_() + this.getCompartmentRotation());
        }
    }

    protected void tickAddAppropriateHelper(AbstractVehicle vehicle) {
        if (this.tickAddCollider(vehicle)) {
            return;
        }
        if (vehicle instanceof IHaveCleats && this.tickAddCleat((IHaveCleats)((Object)vehicle))) {
            return;
        }
        if (vehicle instanceof IHaveSailSwitches && this.tickAddSailSwitch((IHaveSailSwitches)((Object)vehicle))) {
            return;
        }
        if (vehicle instanceof IHaveAnchorWindlass && this.tickAddWindlass((IHaveAnchorWindlass)((Object)vehicle))) {
            return;
        }
        if (vehicle instanceof IHaveMasts && this.tickAddMast((IHaveMasts)((Object)vehicle))) {
            return;
        }
        if (vehicle instanceof IHaveConstructionEntities && this.tickAddConstruction((IHaveConstructionEntities)((Object)vehicle))) {
            return;
        }
        if (this.tickAddCompartment(vehicle)) {
            return;
        }
    }

    protected boolean tickAddCleat(IHaveCleats vehicle) {
        for (int i : vehicle.getCleatIndices()) {
            if (!((Entity)((AbstractVehicle)((Object)vehicle)).m_20197_().get(i)).m_7306_((Entity)this) || ((Entity)((AbstractVehicle)((Object)vehicle)).m_20197_().get(i)).m_20160_()) continue;
            CleatEntity cleat = (CleatEntity)((EntityType)AlekiShipsEntities.VEHICLE_CLEAT_ENTITY.get()).m_20615_(this.m_9236_());
            assert (cleat != null);
            cleat.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            cleat.m_146922_(this.m_20202_().m_146908_());
            if (!cleat.m_20329_(this)) {
                AlekiShips.LOGGER.error("New Cleat: {} unable to ride Vehicle Part: {}", (Object)cleat, (Object)this);
            }
            this.m_9236_().m_7967_((Entity)cleat);
            return true;
        }
        return false;
    }

    protected boolean tickAddCollider(IHaveColliders vehicle) {
        for (int i : vehicle.getColliderIndices()) {
            if (!((Entity)((AbstractVehicle)vehicle).m_20197_().get(i)).m_7306_((Entity)this) || ((Entity)((AbstractVehicle)vehicle).m_20197_().get(i)).m_20160_()) continue;
            ColliderEntity collider = (ColliderEntity)((EntityType)AlekiShipsEntities.VEHICLE_COLLIDER_ENTITY.get()).m_20615_(this.m_9236_());
            assert (collider != null);
            collider.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            if (!collider.m_20329_(this)) {
                AlekiShips.LOGGER.error("New Collider: {} unable to ride Vehicle Part: {}", (Object)collider, (Object)this);
            }
            this.m_9236_().m_7967_((Entity)collider);
            collider.m_6210_();
            return true;
        }
        return false;
    }

    protected boolean tickAddCompartment(AbstractVehicle vehicle) {
        for (int i : vehicle.getCompartmentIndices()) {
            EmptyCompartmentEntity newCompartment;
            if (!((Entity)vehicle.m_20197_().get(i)).m_7306_((Entity)this) || ((Entity)vehicle.m_20197_().get(i)).m_20160_() || (newCompartment = (EmptyCompartmentEntity)((CompartmentType)((Object)AlekiShipsEntities.EMPTY_COMPARTMENT_ENTITY.get())).create(this.m_9236_())) == null) continue;
            newCompartment.m_146922_(this.m_20202_().m_146908_() + this.getCompartmentRotation());
            newCompartment.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            if (!newCompartment.m_20329_(this)) {
                AlekiShips.LOGGER.error("New Compartment: {} unable to ride Vehicle Part: {}", (Object)newCompartment, (Object)this);
            }
            this.m_9236_().m_7967_((Entity)newCompartment);
            return true;
        }
        return false;
    }

    protected boolean tickAddSailSwitch(IHaveSailSwitches vehicle) {
        for (int i : vehicle.getSailSwitchIndices()) {
            if (!((Entity)((AbstractVehicle)((Object)vehicle)).m_20197_().get(i)).m_7306_((Entity)this) || ((Entity)((AbstractVehicle)((Object)vehicle)).m_20197_().get(i)).m_20160_()) continue;
            AbstractSwitchEntity switchEntity = (AbstractSwitchEntity)((EntityType)AlekiShipsEntities.SAIL_SWITCH_ENTITY.get()).m_20615_(this.m_9236_());
            assert (switchEntity != null);
            switchEntity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            if (!switchEntity.m_20329_(this)) {
                AlekiShips.LOGGER.error("New Sail Switch: {} unable to ride Vehicle Part: {}", (Object)switchEntity, (Object)this);
            }
            this.m_9236_().m_7967_((Entity)switchEntity);
            return true;
        }
        return false;
    }

    protected boolean tickAddWindlass(IHaveAnchorWindlass vehicle) {
        for (int i : vehicle.getWindlassIndices()) {
            if (!((Entity)((AbstractVehicle)((Object)vehicle)).m_20197_().get(i)).m_7306_((Entity)this) || ((Entity)((AbstractVehicle)((Object)vehicle)).m_20197_().get(i)).m_20160_()) continue;
            WindlassSwitchEntity windlass = (WindlassSwitchEntity)((EntityType)AlekiShipsEntities.WINDLASS_SWITCH_ENTITY.get()).m_20615_(this.m_9236_());
            assert (windlass != null);
            windlass.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            if (!windlass.m_20329_(this)) {
                AlekiShips.LOGGER.error("New Windlass: {} unable to ride Vehicle Part: {}", (Object)windlass, (Object)this);
            }
            this.m_9236_().m_7967_((Entity)windlass);
            return true;
        }
        return false;
    }

    protected boolean tickAddMast(IHaveMasts vehicle) {
        for (int i : vehicle.getMastIndices()) {
            if (!((Entity)((AbstractVehicle)((Object)vehicle)).m_20197_().get(i)).m_7306_((Entity)this) || ((Entity)((AbstractVehicle)((Object)vehicle)).m_20197_().get(i)).m_20160_()) continue;
            MastEntity mast = (MastEntity)((EntityType)AlekiShipsEntities.MAST_ENTITY.get()).m_20615_(this.m_9236_());
            assert (mast != null);
            mast.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            mast.m_146922_(this.m_20202_().m_146908_());
            if (!mast.m_20329_(this)) {
                AlekiShips.LOGGER.error("New Mast: {} unable to ride Vehicle Part: {}", (Object)mast, (Object)this);
            }
            this.m_9236_().m_7967_((Entity)mast);
            return true;
        }
        return false;
    }

    protected boolean tickAddConstruction(IHaveConstructionEntities vehicle) {
        for (int i : vehicle.getConstructionIndices()) {
            if (!((Entity)((AbstractVehicle)((Object)vehicle)).m_20197_().get(i)).m_7306_((Entity)this) || ((Entity)((AbstractVehicle)((Object)vehicle)).m_20197_().get(i)).m_20160_()) continue;
            ConstructionEntity constructionEntity = (ConstructionEntity)((EntityType)AlekiShipsEntities.CONSTRUCTION_ENTITY.get()).m_20615_(this.m_9236_());
            assert (constructionEntity != null);
            constructionEntity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            constructionEntity.m_146922_(this.m_20202_().m_146908_());
            if (!constructionEntity.m_20329_(this)) {
                AlekiShips.LOGGER.error("New Construction Entity: {} unable to ride Vehicle Part: {}", (Object)constructionEntity, (Object)this);
            }
            this.m_9236_().m_7967_((Entity)constructionEntity);
            return true;
        }
        return false;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_COMPARTMENT_ROTATION, (Object)Float.valueOf(0.0f));
    }

    public void setCompartmentRotation(float rotation) {
        this.f_19804_.m_135381_(DATA_ID_COMPARTMENT_ROTATION, (Object)Float.valueOf(rotation));
    }

    public float getCompartmentRotation() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_COMPARTMENT_ROTATION)).floatValue();
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.setCompartmentRotation(compoundTag.m_128457_("compartmentRotation"));
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128350_("compartmentRotation", this.getCompartmentRotation());
    }

    public Component m_7755_() {
        Entity entity = this.m_20201_();
        if (entity instanceof AbstractVehicle) {
            AbstractVehicle vehicle = (AbstractVehicle)entity;
            return vehicle.m_7755_();
        }
        return super.m_7755_();
    }
}

