/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.block;

import com.alekiponi.alekiships.common.block.BoatFrame;
import java.util.IdentityHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FlatBoatFrameBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape HALF_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private final IdentityHashMap<Item, BoatFrame> boatFrames = new IdentityHashMap();

    public FlatBoatFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public final void registerFrame(Item item, BoatFrame boatFrame) {
        assert (boatFrame instanceof Block) : "Registered Frames must be implemented on a Block";
        this.boatFrames.put(item, boatFrame);
    }

    @Nullable
    protected BoatFrame getFrame(Item item) {
        return this.boatFrames.get(item);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldStack = player.m_21120_(hand);
        BoatFrame frameBlock = this.getFrame(heldStack.m_41720_());
        if (frameBlock == null) {
            return InteractionResult.PASS;
        }
        BlockState frameBlockstate = frameBlock.m_152465_(blockState);
        level.m_46597_(blockPos, frameBlockstate);
        if (!player.m_150110_().f_35937_) {
            heldStack.m_41774_(1);
        }
        SoundType soundType = frameBlockstate.getSoundType((LevelReader)level, blockPos, (Entity)player);
        level.m_5594_(player, blockPos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
        return InteractionResult.SUCCESS;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos neighborPos) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(blockState, direction, neighborState, levelAccessor, blockPos, neighborPos);
    }

    public boolean m_7923_(BlockState pState) {
        return true;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return HALF_SHAPE;
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext placeContext) {
        FluidState fluidState = placeContext.m_43725_().m_6425_(placeContext.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType computationType) {
        return computationType == PathComputationType.WATER && blockGetter.m_6425_(blockPos).m_205070_(FluidTags.f_13131_);
    }
}

