/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.client.render.entity.vehicle.vehiclehelper;

import com.alekiponi.alekiships.client.render.entity.vehicle.vehiclehelper.CompartmentRenderer;
import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.AbstractCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.LidCompartment;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Calendar;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChestCompartmentRenderer<CompartmentEntity extends AbstractCompartmentEntity>
extends CompartmentRenderer<CompartmentEntity> {
    private static final String BOTTOM = "bottom";
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    protected final boolean xmasTextures;
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;

    public ChestCompartmentRenderer(EntityRendererProvider.Context context) {
        super(context);
        Calendar calendar = Calendar.getInstance();
        this.xmasTextures = calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
        ModelPart modelpart = context.m_174023_(ModelLayers.f_171275_);
        this.bottom = modelpart.m_171324_(BOTTOM);
        this.lid = modelpart.m_171324_(LID);
        this.lock = modelpart.m_171324_(LOCK);
    }

    @Override
    protected void renderCompartmentContents(CompartmentEntity compartmentEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        AbstractVehicle vehicle = ((AbstractCompartmentEntity)compartmentEntity).getTrueVehicle();
        if (LightTexture.m_109883_((int)packedLight) < ((AbstractCompartmentEntity)compartmentEntity).getCompartmentBlockLight()) {
            packedLight = LightTexture.m_109885_((int)((AbstractCompartmentEntity)compartmentEntity).getCompartmentBlockLight(), (int)this.m_114508_((Entity)compartmentEntity, compartmentEntity.m_20183_()));
        }
        if (vehicle != null && LightTexture.m_109883_((int)packedLight) < vehicle.getCompartmentBlockLight()) {
            packedLight = LightTexture.m_109885_((int)Math.max(0, vehicle.getCompartmentBlockLight() - 1), (int)this.m_114508_((Entity)compartmentEntity, compartmentEntity.m_20183_()));
        }
        float openAngle = ((LidCompartment)compartmentEntity).getOpenNess(partialTicks);
        openAngle = 1.0f - openAngle;
        openAngle = 1.0f - openAngle * openAngle * openAngle;
        Material material = this.getMaterial(compartmentEntity);
        VertexConsumer vertexConsumer = material.m_119194_(bufferSource, RenderType::m_110452_);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_252880_(-1.0f, 0.0f, -1.0f);
        this.render(poseStack, vertexConsumer, openAngle, packedLight);
    }

    private void render(PoseStack poseStack, VertexConsumer vertexConsumer, float lidAngle, int packedLight) {
        this.lock.f_104203_ = this.lid.f_104203_ = (float)((double)(-lidAngle) * Math.PI / 2.0);
        this.lid.m_104301_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_);
        this.lock.m_104301_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_);
        this.bottom.m_104301_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_);
    }

    protected Material getMaterial(CompartmentEntity compartmentEntity) {
        return this.xmasTextures ? Sheets.f_110748_ : Sheets.f_110751_;
    }
}

