/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketNewFilter
implements IMekanismPacket {
    private final BlockPos pos;
    private final IFilter<?> filter;

    public PacketNewFilter(BlockPos pos, IFilter<?> filter) {
        this.pos = pos;
        this.filter = filter;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        BlockEntity blockEntity;
        ServerPlayer player = context.getSender();
        if (player != null && (blockEntity = WorldUtils.getTileEntity((BlockGetter)player.m_9236_(), this.pos)) instanceof ITileFilterHolder) {
            ITileFilterHolder filterHolder = (ITileFilterHolder)blockEntity;
            filterHolder.getFilterManager().tryAddFilter(this.filter, true);
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        this.filter.write(buffer);
    }

    public static PacketNewFilter decode(FriendlyByteBuf buffer) {
        return new PacketNewFilter(buffer.m_130135_(), BaseFilter.readFromPacket(buffer));
    }
}

